<?php declare(strict_types=1);

namespace EshopCatalog\AdminModule\Components\Products;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\AdminModule\Model\FormContainers\RelatedProductContainer;
use EshopCatalog\AdminModule\Model\Products;
use Nette\Application\AbortException;
use Nette\ComponentModel\IComponent;
use Nette\Utils\ArrayHash;
use Nette\Utils\Strings;

class RelatedProductsForm extends BaseControl
{
	/** @var RelatedProductContainer */
	protected RelatedProductContainer $relatedProductContainer;

	/** @var Products */
	protected Products $products;

	/**
	 * RelatedProductsForm constructor.
	 * @param RelatedProductContainer $relatedProductContainer
	 * @param Products $products
	 */
	public function __construct(RelatedProductContainer $relatedProductContainer, Products $products)
	{
		$this->relatedProductContainer = $relatedProductContainer;
		$this->products = $products;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	/**
	 * @return BaseForm
	 */
	public function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->addComponent($this->relatedProductContainer->getContainer(), 'relatedProducts');

		$this->monitor(IComponent::class, function() use ($form) {
			$form['relatedProducts']['product']->getControlPrototype()->setAttribute('data-link', $this->link('findProducts', ''));
		});

		$form->addSubmit('submit', 'default.save');

		$form->onSuccess[]  = [$this, 'formSuccess'];

		return $form;
	}

	/**
	 * @param BaseForm $form
	 * @param ArrayHash $values
	 */
	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		if ($productsIds = $this->presenter->getParameter('ids')) {
			$products = [];
			foreach (Strings::contains($productsIds, '-') ? explode('-', $productsIds) : [$productsIds] as $productId) {
				if (!$product = $this->products->get((int) $productId)) {
					continue;
				}
				$this->relatedProductContainer->saveData($form->getHttpData(), $product);
				$this->em->persist($product);
			}

			$this->em->flush();
			$this->presenter->flashMessageSuccess('default.saved');
		}
	}

	/**
	 * @param mixed $search
	 * @throws AbortException
	 */
	public function handleFindProducts($search): void
	{
		$this->getPresenter()->sendJson($this->relatedProductContainer->findProducts($search ?? ''));
	}

	/**
	 * @param mixed $ids
	 */
	public function setProducts($ids): void
	{
	}

}