<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Presenters;

use Core\AdminModule\Model\Sites;
use EshopCatalog\AdminModule\Components\Categories\CategoriesGrid;
use EshopCatalog\AdminModule\Components\Categories\CategoryForm;
use EshopCatalog\AdminModule\Components\Categories\ICategoryFormFactory;
use EshopCatalog\AdminModule\Components\Categories\ICategoriesGridFactory;
use EshopCatalog\AdminModule\Model\Categories;
use Core\Model\UI\Form\BaseForm;
use Nette\Application\UI\Multiplier;

/**
 * Class CategoriesPresenter
 * @package EshopCatalog\AdminModule\Presenters
 */
class CategoriesPresenter extends BasePresenter
{
	/** @var Categories @inject */
	public $categoriesService;

	/** @var Sites @inject */
	public $sitesService;

	protected function startup()
	{
		parent::startup();
		$this->setHeader('eshopCatalog.title.categories', 'fa fa-list');
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */
	public function actionDefault(): void
	{
		$this->template->sites = $this->sitesService->getAll();
		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopCatalog.menu.addCategory',
				'link'  => $this->link('add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		]]);
	}

	/*******************************************************************************************************************
	 * ==================================   Handle
	 */

	public function handleAdd(): void
	{
		$this->template->modalTitle       = $this->t('eshopCatalog.title.newCategory');
		$this->template->modal            = 'categoryForm';
		$this->template->modalDialogClass = 'modal-xl';
		$this->redrawControl('modal');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentCategoriesGrid(ICategoriesGridFactory $factory): Multiplier
	{
		return new Multiplier(function(string $sideIdent) use ($factory): CategoriesGrid {
			return $factory->create($sideIdent);
		});
	}

	protected function createComponentCategoryForm(ICategoryFormFactory $category): CategoryForm
	{
		$control = $category->create();
		if ($this->getParameter('id'))
			$control->setCategory((int) $this->getParameter('id'));

		$control['form']->onAnchor[] = function() use ($control) {
			$control['form']->onSuccessSave[]         = function(BaseForm $form) {
				$this['categoriesGrid-' . $form->getCustomData('siteIdent')]->redrawControl('list');
				$this->payload->hideModal = true;
				$this->redrawControl('flashes');
			};
			$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
				$this['categoriesGrid-' . $form->getCustomData('siteIdent')]->redrawControl('list');
				$this->payload->hideModal = true;
				$this->redrawControl('flashes');
			};
			$control['form']['saveControl']->closeModalOnCancel();
		};

		return $control;
	}
}
