<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model;

use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;

/**
 * Class CacheService
 * @package EshopCatalog\FrontModule\Model
 */
class CacheService
{
	/** @var Cache */
	public $defaultCache;

	/** @var Cache */
	public $navigationCache;

	/** @var Cache */
	public $productCache;

	/** @var Cache */
	public $filterCache;

	/** @var Cache */
	public $categoryCache;

	/** @var array */
	protected static $cleaned = [];

	public function __construct(IStorage $cacheStorage)
	{
		$this->defaultCache    = new Cache($cacheStorage, 'eshopCatalog');
		$this->navigationCache = new Cache($cacheStorage, Navigations::CACHE_NAMESPACE);
		$this->productCache    = new Cache($cacheStorage, Products::CACHE_NAMESPACE);
		$this->filterCache     = new Cache($cacheStorage, FilterService::CACHE_NAMESPACE);
		$this->categoryCache   = new Cache($cacheStorage, Categories::CACHE_NAMESPACE);
	}

	public function clean(string $type, array $params)
	{
		if (isset($params[Cache::TAGS])) {
			$tags   = $params[Cache::TAGS];
			$exists = self::$cleaned[$type] ?? [];

			if ($exists) {
				foreach ($tags as $kTag => $tag) {
					if (in_array($tag, $exists))
						unset($tags[$kTag]);
					else {
						self::$cleaned[$type][] = $tag;
						$exists[]               = $tag;
					}
				}
			} else {
				self::$cleaned[$type] = $tags;
			}

			if ($tags) {
				$this->{$type . 'Cache'}->clean([Cache::TAGS => $tags]);
			}
		}
	}
}
