<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Nette\Utils\Html;

class Seller
{
	/** @var string */
	public $title;

	/** @var string */
	public $name;

	/** @var string */
	public $street;

	/** @var string */
	public $city;

	/** @var string */
	public $postal;

	/** @var string */
	public $country;

	/** @var string */
	public $address2;

	/** @var string */
	public $city2;

	/** @var string */
	public $postal2;

	/** @var string */
	public $country2;

	/** @var string */
	public $ic;

	/** @var string */
	public $dic;

	/** @var string */
	public $email;

	/** @var string */
	public $phone;

	/** @var BankAccount|null */
	protected $bankAccount;

	public function getBankAccount(): ?BankAccount { return $this->bankAccount; }

	public function setBankAccount(BankAccount $bankAccount): self
	{
		$this->bankAccount = $bankAccount;

		return $this;
	}

	public function renderAddress(string $number = '', array $skip = []): Html
	{
		$wrap = Html::el();
		$rows = [];

		if ($this->{'street' . $number})
			$wrap->addHtml(Html::el('div')->setText($this->{'street' . $number}));

		$postal = $this->{'postal' . $number} ?? null;
		if ($this->{'city' . $number})
			$wrap->addHtml(Html::el('div')->setText(($postal ? $postal . ', ' : '') . $this->{'city' . $number}));

		if ($this->{'country' . $number} && !in_array('country', $skip))
			$wrap->addHtml(Html::el('div')->setText($this->{'country'}));

		return $wrap;
	}
}
