<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Event;

use EshopCatalog\FrontModule\Model\Dao\Product;
use Symfony\Contracts\EventDispatcher\Event;

class ProductsEvent extends Event
{
	/** @var Product[] */
	public $products;

	/**
	 * ProductsEvent constructor.
	 *
	 * @param Product|Product[] $product
	 */
	public function __construct(&$product)
	{
		if (is_array($product)) {
			foreach ($product as $k => $v) {
				if ($v instanceof Product === false)
					continue;
				$this->products[$k] = &$v;
			}
		} else
			$this->products[$product->getId()] = &$product;
	}
}
