<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Provider;

use Core\Model\Dao\Site;
use Core\Model\Dao\SiteDomain;
use EshopCatalog\FrontModule\Model\Dao\Product;

interface IXmlExportService
{
	public function getName(): string;

	public function setBaseUrl(string $url);

	public function setSite(Site $site);

	public function setDomain(SiteDomain $domain);

	public function startExport();

	public function writeItem(Product $product);

	public function endExport();
}
