<?php declare(strict_types = 1);

namespace EshopCatalog\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use EshopCatalog\Model\Entities\Availability;
use EshopCatalog\Model\Entities\Product;

class AvailabilityService extends BaseFrontEntityService
{
	protected $entityClass = Availability::class;

	/**
	 * Kontrola stavu produktu pokud je vyprodán nebo skladem
	 *
	 * @param Product $product
	 *
	 * @return Product
	 */
	public function updateAvailabilityByQuantity(Product $product): Product
	{
		if ($product->unlimitedQuantity || !$product->getAvailability())
			return $product;

		if ($product->quantity <= 0 && $product->getAvailability()->getIdent() == Availability::IN_STOCK)
			$product->setAvailability($this->getEr()->findOneBy(['ident' => Availability::SOLD_OUT]));
		else if ($product->quantity > 0 && $product->getAvailability()->getIdent() == Availability::SOLD_OUT)
			$product->setAvailability($this->getEr()->findOneBy(['ident' => Availability::IN_STOCK]));

		$this->em->persist($product);

		return $product;
	}
}
