<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="eshop_catalog__availability_text")
 * @ORM\Entity
 */
class AvailabilityText
{

	/**
	 * @var Availability
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Availability", inversedBy="texts")
	 * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $availability;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2, nullable=false)
	 */
	private $lang;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=255, nullable=false)
	 */
	public $name;

	/**
	 * @var string
	 * @ORM\Column(name="description", type="text", nullable=true)
	 */
	public $description;

	public function __construct(Availability $availability, string $lang, string $name)
	{
		$this->availability = $availability;
		$this->lang         = $lang;
		$this->name         = $name;
	}
}

