<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="eshop_catalog__product_document")
 * @ORM\Entity
 */
class ProductDocument
{
	use TId;

	/**
	 * @var Product
	 * @ORM\ManyToOne(targetEntity="Product")
	 * @ORM\JoinColumn(referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	public $product;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", length=2, nullable=true)
	 */
	public $lang;

	/**
	 * @var string
	 * @ORM\Column(type="string", nullable=false)
	 */
	public $name;

	/**
	 * @var string
	 * @ORM\Column(type="string", nullable=false)
	 */
	public $file;

	/**
	 * ProductDocument constructor.
	 *
	 * @param string  $lang
	 * @param string  $name
	 * @param string  $file
	 * @param Product $product
	 */
	public function __construct(string $lang, string $name, string $file, Product $product)
	{
		$this->lang    = $lang;
		$this->name    = $name;
		$this->file    = $file;
		$this->product = $product;
	}

	public function isSecured(): bool { return strpos($this->file, '/secured') === 0; }

	public function getFullPath(): string { return ($this->isSecured() ? APP_DIR : WWW_DIR) . $this->file; }
}
