<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_catalog__product_supplier")
 */
class ProductSupplier
{

	/**
	 * @var Product
	 *
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Product", inversedBy="suppliers")
	 * @ORM\JoinColumn(name="id_product", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $product;

	/**
	 * @var Supplier
	 *
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Supplier", inversedBy="product")
	 * @ORM\JoinColumn(name="id_supplier", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $supplier;

	/**
	 * @var int
	 * @ORM\Column(name="quantity", type="integer")
	 */
	public $quantity;

	/**
	 * @var string
	 * @ORM\Column(name="code", type="string")
	 */
	public $code;

	public function __construct($product, $supplier)
	{
		$this->product  = $product;
		$this->supplier = $supplier;
		$this->quantity = 0;
	}

	public function getProduct() { return $this->product; }

	public function setSupplier($supplier) { $this->supplier = $supplier; }

	public function getSupplier() { return $this->supplier; }
}
