<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="eshop_catalog__supplier_texts")
 * @ORM\Entity
 */
class SupplierTexts
{
    /**
     * @ORM\Id
     * @ORM\ManyToOne(targetEntity="Supplier", inversedBy="SupplierTexts", cascade={"persist", "remove"})
     * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
     */
    private $id;

    /**
     * @ORM\Id
     * @ORM\Column(name="lang", type="string", length=2)
     */
    private $lang;

    /**
     * @var string
     * @ORM\Column(name="description", type="text", nullable=true)
     */
    public $description;

    public function __construct($id, $lang)
    {
        $this->id = $id;
        $this->lang = $lang;
    }

    public function getLang()
    {
        return $this->lang;
    }
}
