<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Export;

use Core\Model\Helpers\BaseService;
use EshopCatalog\FrontModule\Model\Provider\IXmlExportService;

/**
 * TODO exporty načítat pomocí Interface
 *
 * Class XmlExport
 * @package EshopCatalog\FrontModule\Model
 */
class XmlExportCollection extends BaseService
{
	/** @var IXmlExportService[] */
	protected $services = [];

	/** @return IXmlExportService[] */
	public function getServices(): array { return $this->services; }

	/**
	 * @param IXmlExportService[] $services
	 */
	public function setServices(array $services): void
	{
		foreach ($services as $service)
			$this->services[$service->getName()] = $service;
	}
}
