<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="eshop_catalog__tag")
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener", "TagListener"})
 */
class Tag
{
	use Identifier;
	use MagicAccessors;
	use TTranslateListener;

	/**
	 * @var string
	 * @ORM\Column(name="type", type="string")
	 */
	public $type;

	/**
	 * @var TagText[]
	 *
	 * @ORM\OneToMany(targetEntity="TagText", mappedBy="tag", indexBy="lang", cascade={"all"})
	 */
	protected $texts;

	/**
	 * @var string
	 * @ORM\Column(name="image", type="string", nullable=true, length=255)
	 */
	public $image;

	/**
	 * @var string
	 * @ORM\Column(name="color", type="string", nullable=true)
	 */
	public $color;
	/**
	 * @var string
	 * @ORM\Column(name="bg_color", type="string", nullable=true)
	 */
	public $bgColor;

	/**
	 * Tag constructor.
	 */
	public function __construct()
	{
		$this->texts = new ArrayCollection();
	}

	/**
	 * @param TagText $tagText
	 */
	public function setText(TagText $tagText)
	{
		$this->texts->set($tagText->getLang(), $tagText);
	}

	public function setTexts(array $tagTexts): self
	{
		$this->texts = new ArrayCollection($tagTexts);

		return $this;
	}

	/**
	 * @param string|null $lang
	 *
	 * @return TagText|null
	 */
	public function getText($lang = null)
	{
		return $this->texts->get($lang ?: $this->locale);
	}

	/**
	 * @return ArrayCollection|TagText[]
	 */
	public function getTexts() { return $this->texts; }
}
