<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

class ExportEnums
{

	const SERVICE_HEUREKA = 'heureka';
	const SERVICE_ZBOZI   = 'zbozi';
	const SERVICE_GOOGLE  = 'google';

	const STATUS_DISABLED = 0;
	const STATUS_ACTIVE   = 1;
	const STATUS_INHERIT  = 2;

	static $services = [
		self::SERVICE_HEUREKA => [
			'title'  => 'eshopCatalog.porovnavace.' . self::SERVICE_HEUREKA . '.title',
			'fields' => [
				'productName', 'product', 'categoryText', 'bidCpc',
			],
		],
		self::SERVICE_ZBOZI   => [
			'title'  => 'eshopCatalog.porovnavace.' . self::SERVICE_ZBOZI . '.title',
			'fields' => [
				'productName', 'product', 'categoryText', 'bidCpc',
			],
		],
		self::SERVICE_GOOGLE  => [
			'title'  => 'eshopCatalog.porovnavace.' . self::SERVICE_GOOGLE . '.title',
			'fields' => [
				'product', 'categoryText',
			],
		],
	];

	static $statuses = [
		self::STATUS_DISABLED => [
			'title'    => 'eshopCatalog.porovnavace.statuses.disabled',
			'btnClass' => 'danger',
		],
		self::STATUS_ACTIVE   => [
			'title'    => 'eshopCatalog.porovnavace.statuses.active',
			'btnClass' => 'success',
		],
		self::STATUS_INHERIT  => [
			'title'    => 'eshopCatalog.porovnavace.statuses.inherit',
			'btnClass' => 'secondary',
		],
	];

	public static function statusesForSelect(): array
	{
		$arr = self::$statuses;

		array_walk($arr, function(&$a, $b) { $a = $a['title']; });

		return $arr;
	}

	public static function validateService(string $service): bool
	{
		return array_key_exists($service, self::$services);
	}
}
