const instantFilterSwitch = document.getElementById('products-grid-filter-submit-switch__input');
if (instantFilterSwitch) {
	instantFilterSwitch.addEventListener('change', e => {
		window.location.href = instantFilterSwitch.dataset.link.replace('__val__', instantFilterSwitch.checked === true ? 1 : 0);
	})
}

document.addEventListener('autocompleteOnSelection', e => {
	if (e.detail.name === "eshopCatalogProductsFeatures") {
		let key  = e.detail.selection.value.k;
		let name = e.detail.selection.value.name;

		let input = document.getElementById(e.detail.inputId);

		if (input) {
			input.value = key + ' | ' + name;

			input.closest('form').dispatchEvent(new Event('submit'));
		}
	}
})

const initFeatureAutoSubmit = () => {
	document.querySelectorAll('[name="filter[feature]"], [name="filter[featureNot]"]').forEach(input => {
		input.removeAttribute('data-autosubmit');

		const wrap     = input.closest('.form-group');
		const clearBtn = wrap.querySelector('.filter-feature-clear');

		if (clearBtn.clickInited !== true) {
			clearBtn.clickInited = true;
			input.addEventListener('focus', e=> {
				input.removeAttribute('data-autosubmit');
			});

			clearBtn.addEventListener('click', e => {
				e.preventDefault();

				input.value = '';
				input.closest('form').dispatchEvent(new Event('submit'));

				return false;
			});
		}
	});
}

initFeatureAutoSubmit();
