import {tns} from "tiny-slider/src/tiny-slider";

const initProductCardHandler = () => {
	for (const el of document.querySelectorAll('.product-card > a')) {
		el.addEventListener('click', async e => {
			let id = null
			if (e.target.tagName !== 'A') {
				id = e.target.closest('a').dataset.id
			} else {
				id = e.target.dataset.id
			}

			window.disableLoader = true

			global.naja.makeRequest('post', window.personalizationAlternativeProducts.apiUrlCtr, {productId: id}, {
				history: false,
			})
		})
	}
}

const initAlternativeProductsSlider = () => {
	const elementId = 'alternative-products-slider'
	const sliderEl = document.getElementById(elementId)

	if (sliderEl) {
		const slider = tns({
			container: sliderEl,
			controls: true,
			autoplayButtonOutput: false,
			nav: false,
			mouseDrag: true,
			gutter: 5,
			responsive: {
				0: {
					items: 1
				},
				767: {
					items: 2
				},
				992: {
					items: 3
				},
				1200: {
					items: 4
				}
			},
			controlsContainer: '#alternative-products-slider-buttons'
		})
	}
}

document.addEventListener('DOMContentLoaded', e => {
	initProductCardHandler()
	initAlternativeProductsSlider()
})