import {tns} from "tiny-slider/src/tiny-slider";

const initRecentlyViewedProductsSlider = () => {
	const elementId = 'recently-viewed-products-slider'
	const sliderEl = document.getElementById(elementId)

	if (sliderEl) {
		const slider = tns({
			container: sliderEl,
			controls: true,
			autoplayButtonOutput: false,
			nav: false,
			mouseDrag: true,
			gutter: 5,
			responsive: {
				0: {
					items: 1
				},
				767: {
					items: 2
				},
				992: {
					items: 3
				},
				1200: {
					items: 4
				}
			},
			controlsContainer: '#recently-viewed-products-slider-buttons'
		})
	}
}

document.addEventListener('DOMContentLoaded', e => {
	initRecentlyViewedProductsSlider()
})