<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model\Helpers;

use Core\AdminModule\Model\Sites;
use Core\Model\Countries;
use EshopCatalog\AdminModule\Model\AvailabilityService;
use EshopCatalog\AdminModule\Model\ProductPriceLevels;
use EshopCatalog\Model\Config;
use EshopOrders\AdminModule\Model\GroupsCustomers;
use EshopOrders\Model\Entities\GroupCustomers;

class ProductFormHelper
{
	/** @var GroupsCustomers|null @inject */
	public ?GroupsCustomers $groupsCustomersService = null;

	/** @var ProductPriceLevels|null @inject */
	public ?ProductPriceLevels $productPriceLevelsService = null;

	/** @var AvailabilityService|null @inject */
	public ?AvailabilityService $availabilityService = null;

	/** @var Config|null @inject */
	public ?Config $config = null;

	/** @var Sites|null @inject */
	public ?Sites $sitesService = null;

	/** @var GroupCustomers[]|null */
	protected ?array $groupCustomers = null;

	/** @var Countries @inject */
	public $countries = null;

	/**
	 * @return GroupCustomers[]
	 */
	public function getGroupCustomers(): array
	{
		if ($this->groupCustomers === null) {
			$this->groupCustomers = $this->groupsCustomersService->getEr()->createQueryBuilder('g', 'g.id')->getQuery()
																 ->getResult();
		}

		return $this->groupCustomers;
	}

}