<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model\Repository;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPosition;
use Core\Model\Helpers\Traits\TPublish;
use Doctrine\ORM\Query\Expr\Join;
use EshopCatalog\Model\Entities\RelatedGroup;

/**
 * @method RelatedGroup|null getReference($id)
 * @method RelatedGroup[] getAll()
 * @method RelatedGroup|null get($id)
 */
class RelatedGroups extends BaseEntityService
{
	use TPublish;
	use TPosition;

	protected $entityClass = RelatedGroup::class;
	protected Translator $translator;

	public function __construct(Translator $translator)
	{
		$this->translator = $translator;
	}

	public function getOptionsForSelect(): array
	{
		$result = [];

		foreach ($this->getEr()->createQueryBuilder('rg')->select('rg.id, rgt.name')
			         ->innerJoin('rg.texts', 'rgt', Join::WITH, 'rgt.lang = :lang')
			         ->setParameter('lang', $this->translator->getLocale())
			         ->orderBy('rg.position')
			         ->getQuery()->getArrayResult() as $row) {
			$result[$row['id']] = $row['name'];
		}

		return $result;
	}

}