<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Presenters;

use EshopCatalog\AdminModule\Components\Search\HistoryGrid;
use EshopCatalog\AdminModule\Components\Search\IHistoryGridFactory;

class SearchPresenter extends BasePresenter
{
	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionHistory(): void
	{
		$this->setHeader('eshopCatalog.title.searchHistory', 'fas fa-history');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentSearchHistoryGrid(IHistoryGridFactory $factory): HistoryGrid
	{
		return $factory->create();
	}
}
