<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Presenters;

use EshopCatalog\AdminModule\Components\Sorting\Products\IProductsGridFactory;
use EshopCatalog\AdminModule\Components\Sorting\Products\ProductsGrid;

class SortingPresenter extends BasePresenter
{
	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionProducts(): void
	{
		$this->setHeader('eshopCatalog.title.sortingProducts', 'fas fa-sort');
	}

	public function actionProductSet(): void
	{
		try {
			$productId = (int) $this->getHttpRequest()->getQuery('product');
			$position  = $this->getHttpRequest()->getQuery('position');

			$this['productsGrid']->handleGridSortableRow($productId, is_numeric($position) ? (int) $position : null);
		} catch (\Exception $e) {
			$this->flashMessageDanger('default.error');
		}

		$this->redrawControl('flashes');
		$this->template->setFile(__DIR__ . '/../Templates/Sorting/products.latte');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentProductsGrid(IProductsGridFactory $factory): ProductsGrid
	{
		return $factory->create();
	}
}
