<?php declare(strict_types = 1);

namespace EshopCatalog\CronModule\Presenters;

use EshopCatalog\FrontModule\Model\Manufacturers;
use Nette\Application\ForbiddenRequestException;

class ManufacturersPresenter extends BasePresenter
{
	protected Manufacturers $manufacturers;

	public function __construct(
		Manufacturers $manufacturers
	)
	{
		$this->manufacturers = $manufacturers;
	}

	public function actionManufacturers(): void
	{
		if (!$this->getUser()->isAllowed('Core:Admin', 'access')) {
			throw new ForbiddenRequestException;
		}

		$lang = $this->getParameter('lang', null);
		if ($lang) {
			$this->translator->setLocale($lang);
		}

		$data = [];
		foreach ($this->manufacturers->getManufacturers() as $manu) {
			$manu       = (array) $manu;
			$manu['id'] = (string) $manu['id'];

			$data[] = $manu;
		}

		$this->sendJson($data);
	}

}
