<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components\Personalization;

use EshopCatalog\Model\Personalization\Personalization;
use EshopCatalog\Model\Personalization\PersonalizationAccessControl;

class RecentlyViewedProduct extends PersonalizationControl
{
	protected Personalization $personalization;
	protected PersonalizationAccessControl $personalizationAccessControl;

	public function __construct(
		Personalization $personalization,
		PersonalizationAccessControl $personalizationAccessControl
	)
	{
		$this->personalization = $personalization;
		$this->personalizationAccessControl = $personalizationAccessControl;
	}

	public function render(int $productId): void
	{
		$this->template->apiUrlNotifyView = $this->link('notifyView!');
		$this->template->productId = $productId;
		$this->template->render($this->getTemplateFile());
	}

	public function handleNotifyView(): void
	{
		$req = $this->presenter->request;
		$this->personalization->notifyView((int) $req->getPost('productId'));
	}

	public function isAllowed(): bool
	{
		return $this->personalizationAccessControl->isRecentlyViewedProductsAllowed();
	}

}