<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use EshopCatalog\FrontModule\Model\Dao\FeatureProduct;
use EshopCatalog\Model\Entities\DynamicFeatureProduct;
use EshopCatalog\Model\Entities\Feature;
use Nette\Caching\Cache;

class DynamicFeaturesProducts extends BaseFrontEntityService
{
	public const CACHE_NAMESPACE = 'dynamicFeaturesProducts';

	protected              $entityClass = DynamicFeatureProduct::class;
	protected CacheService $cacheService;
	protected Features     $features;

	/** @var array */
	protected $cacheDep = [
		Cache::TAGS   => ['dynamicFeaturesProducts'],
		Cache::EXPIRE => '1 week',
	];

	public function __construct(
		CacheService $cacheService,
		Features     $features
	)
	{
		$this->cacheService = $cacheService;
		$this->features     = $features;
	}

	public function getCache(): Cache
	{
		if ($this->cache === null) {
			$this->cache = new Cache($this->cacheStorage, self::CACHE_NAMESPACE);
		}

		return $this->cache;
	}

	public function getDaoByProducts(array $ids): array
	{
		if (empty($ids)) {
			return [];
		}

		$arr = [];

		foreach ($this->getEr()->createQueryBuilder('dfp')->select('dfp.id, IDENTITY(dfp.product) as product, IDENTITY(dfp.feature) as feature, dfp.value, f.unit, f.showInProduct, f.showInExport')
			         ->innerJoin('dfp.feature', 'f')
			         ->where('dfp.product IN (' . implode(',', $ids) . ')')
			         ->getQuery()->getArrayResult() as $row) {
			$feature = $this->features->getFeatureById((int) $row['feature']);
			if (!$feature) {
				continue;
			}

			$unit = $feature['unit'];
			if ($unit === 'month') {
				$unit = $this->translator->translate('eshopCatalogFront.unit.month');
			}

			$dao                    = new FeatureProduct;
			$dao->idFeature         = $feature['id'];
			$dao->name              = $feature['name'];
			$dao->position          = $feature['position'];
			$dao->showInProduct     = (int) $feature['showInProduct'];
			$dao->showInExport      = (int) $feature['showInExport'];
			$dao->value             = $row['value'] . ($unit ? ' ' . $unit : '');
			$dao->rawValue          = $row['value'];
			$dao->unit              = $row['unit'];
			$dao->useForVariantDiff = (int) $feature['useForVariantDiff'];
			$dao->type              = Feature::TYPE_RANGE;

			$arr[$row['product']][$row['feature']][$row['id']] = $dao;
		}

		return $arr;
	}

}
