<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Helpers;

use Contributte\Translation\Translator;
use Core\FrontModule\Model\PublicHolidays;
use Core\Model\Helpers\Strings;
use Core\Model\Settings;
use Core\Model\Sites;
use Navigations\Model\Navigations;

class ProductsHelper
{
	protected Settings       $settings;
	protected Sites          $sites;
	protected PublicHolidays $publicHolidays;
	protected Navigations    $navigations;
	protected Translator     $translator;

	public function __construct(
		Settings       $settings,
		Sites          $sites,
		PublicHolidays $publicHolidays,
		Navigations    $navigations,
		Translator     $translator
	)
	{
		$this->settings       = $settings;
		$this->sites          = $sites;
		$this->publicHolidays = $publicHolidays;
		$this->navigations    = $navigations;
		$this->translator     = $translator;
	}

	public function getDeliveryToDate(): ?\DateTime
	{
		$siteIdent = $this->sites->getCurrentSite()->getIdent();

		$timeTo = $this->settings->getByKey('eshopCatalog' . Strings::firstUpper($siteIdent) . 'DeliveryExpeditionTo');
		if (!$timeTo) {
			return null;
		}

		$baseDays = (int) $this->settings->getByKey('eshopCatalog' . Strings::firstUpper($siteIdent) . 'DeliveryExpeditionDeliveryBaseDays') ?: 1;

		$skipDates = array_keys($this->publicHolidays->getAll());
		$skipDates = array_flip($skipDates);

		$deliveryDate = new \DateTime();
		$deliveryDate->modify('+' . $baseDays . ' day');

		if ($deliveryDate->format('H:i') > $timeTo) {
			$deliveryDate->modify('+1 day');
		}

		while (isset($skipDates[$deliveryDate->format('Y-m-d')]) || in_array((int) $deliveryDate->format('N'), [6, 7], true)) {
			$deliveryDate->modify('+1 day');
		}

		return $deliveryDate;
	}

	public function getDeliveryToDescription(): ?string
	{
		$siteIdent = $this->sites->getCurrentSite()->getIdent();

		$description = $this->settings->getByKey('eshopCatalog' . Strings::firstUpper($siteIdent) . 'DeliveryExpeditionToDesc');
		if (!$description || !is_string($description)) {
			return null;
		}

		$page = $this->settings->getByKey('eshopCatalog' . Strings::firstUpper($siteIdent) . 'DeliveryPage');
		if ($page) {
			$nav = $this->navigations->getNavigation($page, $this->translator->getLocale());

			if ($nav) {
				$description .= ' <a href="' . $nav->getLink() . '" target="_blank">' . $this->translator->translate('eshopCatalogFront.product.moreAboutDelivery') . '</a>';
			}
		}

		return nl2br($description);
	}
}
