<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Config;
use Exception;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Navigations\Model\Navigations;
use Contributte\Translation\Translator;
use Nette\Caching\Cache;
use Nette\SmartObject;
use Tracy\Debugger;
use Users\Model\Security\User;

class CategoryTextListener implements EventSubscriberInterface
{
	use SmartObject;

	protected static array $cleared = [];
	protected CacheService $cacheService;
	protected Translator $translator;
	protected ?User $user = null;

	public function __construct(Translator $translator, CacheService $cacheService, User $user)
	{
		$this->cacheService = $cacheService;
		$this->translator   = $translator;
		if ($user->isLoggedIn()) {
			$this->user = $user;
		}
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostUpdate
	 */
	public function postUpdateHandler(CategoryTexts $categoryText, LifecycleEventArgs $event): void
	{
		if (!self::$cleared[$categoryText->getCategory()->getId()]) {
			$em        = $event->getEntityManager();
			$changeSet = $em->getUnitOfWork()->getEntityChangeSet($categoryText);

			if (isset($changeSet['alias'])) {
				$this->cacheService->clean('navigation', [
					Cache::TAGS => [Navigations::CACHE_NAMESPACE],
				]);
			}
		}

		if (Config::load('allowLogCategoryShortDescChanges', false)) {
			$changeSet = $event->getEntityManager()->getUnitOfWork()->getEntityChangeSet($categoryText);

			if (isset($changeSet['shortDescription'])) {
				try {
					throw new Exception;
				} catch (Exception $e) {
					Debugger::log($e, 'categoryShortDescChanges');
					Debugger::log([
						'entityId' => $categoryText->id->getId(),
						'changeSet' => $changeSet['shortDescription'],
					], 'categoryShortDescChanges-moreinfo');
				}
			}
		}

		self::$cleared[$categoryText->getCategory()->getId()] = true;
	}

}