<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class FeatureListener implements EventSubscriberInterface
{
	use SmartObject;

	protected CacheService $cacheService;

	public function __construct(
		CacheService $cacheService
	)
	{
		$this->cacheService = $cacheService;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param Feature|object $entity
	 */
	public function onPreFlush(object $entity, Doctrine\ORM\Event\PreFlushEventArgs $args): void
	{
		$this->cacheService->clearFeatures();
	}
}
