<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Core\Model\Helpers\Traits\TExtraField;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\Common\Collections\ArrayCollection;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="eshop_catalog__feature_value", indexes={@ORM\Index(name="published", columns={"id", "is_published"})})
 * @ORM\Entity
 * @ORM\EntityListeners({"FeatureValueListener", "Core\Model\Entities\TranslateListener"})
 */
class FeatureValue
{
	use TId;
	use TTranslateListener;
	use TExtraField;

	public const EXTRA_FIELD_SECTION = 'eshopCatalogFeatureValue';

	/**
	 * @Gedmo\SortableGroup
	 * @ORM\ManyToOne(targetEntity="Feature", inversedBy="id", cascade={"persist"})
	 * @ORM\JoinColumn(name="feature_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected ?Feature $feature = null;

	/**
	 * @var Collection<string, FeatureValueTexts>
	 * @ORM\OneToMany(targetEntity="FeatureValueTexts", mappedBy="id", indexBy="lang")
	 */
	protected Collection $featureValueTexts;

	/**
	 * @Gedmo\SortablePosition
	 * @ORM\Column(type="integer")
	 */
	private int $position;

	/**
	 * @var int|bool|null
	 * @ORM\Column(type="smallint", nullable=true, options={"default"=0})
	 */
	public $isPublished;

	/**
	 * @ORM\Column(name="value1", type="string", length=255, nullable=true)
	 */
	public ?string $value1 = null;

	/**
	 * @ORM\Column(type="smallint", nullable=false, options={"default"=0})
	 */
	public int $showAsTag = 0;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $moreLink = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $image = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $tagTextColor = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $tagBgColor = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $googleType = null;

	/**
	 * @ORM\Column(type="smallint", nullable=true, options={"unsigned": true})
	 */
	public ?int $seoNoFollow = null;

	public function __construct()
	{
		$this->featureValueTexts = new ArrayCollection;
		$this->isPublished       = 1;
		$this->setPosition(-1);
		$this->extraFields = new ArrayCollection;
	}

	public function addFeatureValueText(string $lang): void
	{
		$this->featureValueTexts->set($lang, new FeatureValueTexts($this, $lang));
	}

	public function getFeatureValueText(?string $lang = null): ?FeatureValueTexts { return $this->featureValueTexts[$lang ?? $this->locale] ?: null; }

	/**
	 * @return Collection<string, FeatureValueTexts>
	 */
	public function getFeatureValueTexts(): Collection { return $this->featureValueTexts; }

	public function setFeature(Feature $feature): void
	{
		$this->feature = $feature;
	}

	public function setFeatureValueText(FeatureValueTexts $featureValueTexts): void
	{
		$this->featureValueTexts->set($featureValueTexts->getLang(), $featureValueTexts);
	}

	public function setTexts(array $texts): void
	{
		$this->featureValueTexts = new ArrayCollection($texts);
	}

	public function getFeature(): ?Feature
	{
		return $this->feature;
	}

	public function setPosition(int $position): self
	{
		$this->position = $position;

		return $this;
	}

	public function getPosition(): int { return $this->position; }

}
