<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_catalog__package_item")
 */
class PackageItem
{
	use TIdUnsigned;

	/**
	 * @ORM\ManyToOne(targetEntity="Package", cascade={"persist"})
	 * @ORM\JoinColumn(name="package_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	protected Package $package;

	/**
	 * @ORM\ManyToOne(targetEntity="Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	protected Product $product;

	/**
	 * @ORM\Column(type="integer", options={"default": 1, "unsigned": true}, nullable=false)
	 */
	public int $quantity = 1;

	public function __construct(
		Package $package,
		Product $product
	)
	{
		$this->package = $package;
		$this->product = $product;
	}

	public function getPackage(): Package { return $this->package; }

	public function getProduct(): Product { return $this->product; }
}
