<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Spedition;

/**
 * @ORM\Table(name="eshop_catalog__product_spedition")
 * @ORM\Entity
 */
class ProductSpedition
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Product", inversedBy="speditions")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	public Product $product;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopOrders\Model\Entities\Spedition")
	 * @ORM\JoinColumn(name="spedition_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	public Spedition $spedition;

	/**
	 * @ORM\Column(name="delivery_disabled", type="smallint", length=1, options={"default": 0})
	 */
	public int $speditionDisabled = 0;

	public function __construct(Product $product, Spedition $spedition)
	{
		$this->product   = $product;
		$this->spedition = $spedition;
	}

}