<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use DateTimeInterface;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

/**
 * @ORM\Table(name="eshop_catalog__product_variant", indexes={
 *       @ORM\Index(name="variantId", columns={"variant_id"}),
 *   })
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener"})
 */
class ProductVariant
{
	use TTranslateListener;

	/**
	 * @ORM\Id
	 * @ORM\OneToOne(targetEntity="Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Product $product;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $variantName = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	protected string $variantId;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $isDefault;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useName;

	/**
	 * @ORM\Column(name="use_name2", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useName2;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $usePrice;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useRetailPrice;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $usePurchasePrice;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useShortDescription;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useDescription;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $usePriceLevels;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useUnlimitedQuantity;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useDiscountDisabled;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useCategoryGiftsAllowed = 0;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useOrderGiftsAllowed = 0;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useGifts;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useExport;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useLabels;

	/**
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $useImportPrice;

	/**
	 * @ORM\Column(type="integer", nullable=true, options={"unsigned": true})
	 */
	public ?int $defaultImage = null;

	/**
	 * @ORM\Column(type="datetime")
	 */
	public DateTimeInterface $createdDefault;

	/**
	 * @var Collection<string, ProductVariantText>
	 * @ORM\OneToMany(targetEntity="ProductVariantText", mappedBy="variant", indexBy="lang")
	 */
	public Collection $texts;

	public function __construct(Product $product, string $variantId)
	{
		$this->product   = $product;
		$this->variantId = $variantId;

		$this->isDefault               = 0;
		$this->useName                 = 0;
		$this->useName2                = 0;
		$this->usePrice                = 0;
		$this->useRetailPrice          = 0;
		$this->usePurchasePrice        = 0;
		$this->useShortDescription     = 0;
		$this->useDescription          = 0;
		$this->usePriceLevels          = 0;
		$this->useUnlimitedQuantity    = 0;
		$this->useDiscountDisabled     = 0;
		$this->useCategoryGiftsAllowed = 0;
		$this->useOrderGiftsAllowed    = 0;
		$this->useGifts                = 0;
		$this->useExport               = 0;
		$this->useLabels               = 0;
		$this->useImportPrice          = 0;

		$this->createdDefault = new DateTime;
		$this->texts          = new ArrayCollection;
	}

	public function getProduct(): Product { return $this->product; }

	public function getVariantId(): string { return $this->variantId; }

	public function setVariantId(string $id): void { $this->variantId = $id; }

	public function getText(?string $lang = null): ?ProductVariantText
	{
		return $this->texts->get($lang ?? $this->locale) ?? null;
	}

}
