<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="eshop_catalog__vat_rate")
 * @ORM\Entity
 */
class VatRate
{
	use TId;

	/**
	 * @ORM\Column(type="string", length=255)
	 */
	public string $name;

	/**
	 * @ORM\Column(type="smallint")
	 */
	public int $rate;

	/**
	 * @ORM\Column(type="string", length=10, nullable=true)
	 */
	public ?string $pohodaRate = null;

	/**
	 * @Gedmo\SortablePosition
	 * @ORM\Column(type="integer")
	 */
	protected int $position;

	public function __construct()
	{
		$this->setPosition(-1);
	}

	public function getModifier(): float
	{
		return round($this->rate / 100 * 1, 2);
	}

	public function getPosition(): int { return $this->position; }

	public function setPosition(int $position): self
	{
		$this->position = $position;

		return $this;
	}
}
