<?php declare(strict_types = 1);

namespace EshopCatalog\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Contributte\Translation\Translator;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use EshopCatalog\FrontModule\Model\Features;

class FeatureValues extends TemplateTextType implements ITemplateTextType
{
	protected $type = 'eshopCatalogTagValues';

	protected Features   $featuresService;
	protected Translator $translator;

	public function __construct(
		Features   $features,
		Translator $translator
	)
	{
		$this->featuresService = $features;
		$this->translator      = $translator;
	}

	/**
	 * @inheritDoc
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		if (!isset($params['tag'])) {
			$features = $this->featuresService->getPublishedFeatures();

			$formContainer->addSelect($this->getName(), $this->getTitle(), $features);
		}
	}

	public function render(array $params): ?array
	{
		$featureId = isset($params['tag']) ? (int) $params['tag'] : (int) $this->getDefault();

		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		$feature = $this->featuresService->getFeatureById($featureId);

		return $feature ? [
			'id'     => $feature['id'],
			'name'   => $feature['name'],
			'values' => $this->featuresService->getValuesByFeatureId($featureId),
		] : null;
	}

}
