<?php declare(strict_types = 1);

namespace EshopCatalog\Model\TemplateTextType;

use Core\AdminModule\Model\Sites;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\Controls\SelectInput;
use EshopCatalog\AdminModule\Model\Categories as AdminCategories;
use EshopCatalog\FrontModule\Model\Categories as FrontCategories;
use Contributte\Translation\Translator;

class SelectedCategories extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'eshopCatalogSelectedCategories';

	protected Sites           $sites;
	protected FrontCategories $frontCategories;
	protected AdminCategories $adminCategories;
	protected Translator      $translator;

	public function __construct(
		Sites           $sites,
		FrontCategories $frontCategories,
		AdminCategories $adminCategories,
		Translator      $translator
	)
	{
		$this->sites           = $sites;
		$this->frontCategories = $frontCategories;
		$this->adminCategories = $adminCategories;
		$this->translator      = $translator;
	}

	/**
	 * @inheritDoc
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		if ((bool)$params['sortable'] === true) {
			$parent = $formContainer->getParent();
			$rootId = null;
			if ($parent) {
				/** @var SelectInput|null $siteComponent */
				$siteComponent = $parent->getComponent('site');

				if ($siteComponent) {
					$site = $siteComponent->getValue();

					if ($site) {
						$rootId = $this->frontCategories->getRootIdForSite((string) $site);
					}
				}
			}

			$formContainer->addSortableCheckboxList($this->getName(), $this->getTitle(), $this->frontCategories->getCategoriesPath($rootId));
		} else {
			$sites = $this->sites->getAll();
			if (count($sites) > 1) {
				$flat = [];
				foreach ($sites as $site) {
					$tmp = $this->adminCategories->getFlatTree($site->getIdent());

					if (empty($tmp)) {
						continue;
					}

					$flat[] = [
						'id'     => $tmp[0]['parent'],
						'parent' => 0,
						'name'   => $site->getIdent(),
					];

					$flat = array_merge($flat, $tmp);
				}
			} else {
				$flat = $this->adminCategories->getFlatTree();
			}

			$formContainer->addCheckboxNestedList($this->getName(), $this->getTitle(), $flat);
		}
	}

	/**
	 * @return array
	 */
	public function render(array $params)
	{
		$default = $this->getDefault();

		if (!$default || !is_array($default)) {
			return [];
		}

		if (!isset($params['toVar'])) {
			return [];
		}

		$categories = [];
		foreach ($default as $id) {
			$categories[(int) $id] = $this->frontCategories->get((int) $id);
		}

		return $categories;
	}

}
