<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Nette\Neon\Neon;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20191215175400 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');


		$this->addSql('UPDATE eshop_catalog__category SET lvl = 0 WHERE lvl = 0');
	}

	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$configFile = @file_get_contents(APP_DIR . '/config/app/parameters.neon');
		$appConfig  = Neon::decode((string) $configFile);
		$siteName   = $appConfig['parameters']['siteNameAlias'] ?? 'pshkcmssandbox';

		$lvl0Id = $this->connection->fetchColumn('SELECT id FROM eshop_catalog__category WHERE lvl = :lvl LIMIT 1', [
			'lvl' => 0,
		], 0);

		if ($lvl0Id) {
			$this->connection->update('eshop_catalog__category_texts', [
				'name'  => $siteName,
				'alias' => $siteName,
			], [
				'id' => $lvl0Id,
			]);
		}
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');
	}
}
