<?php declare(strict_types=1);

namespace EshopCatalog\AdminModule\Model\FormContainers;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\AdminModule\Model\AvailabilityService;
use EshopCatalog\AdminModule\Model\Products;
use EshopCatalog\AdminModule\Model\Suppliers;
use EshopCatalog\Model\Entities\Availability;
use EshopCatalog\Model\Entities\Product;
use EshopCatalog\Model\Entities\ProductSupplier;
use EshopCatalog\Model\Entities\Supplier;
use Nette\Localization\ITranslator;

class ProductSupplierContainer
{
	protected ITranslator $translator;
	protected EntityManagerDecorator $em;
	protected Products $products;
	protected AvailabilityService $availabilityService;

	public function __construct(ITranslator $translator, EntityManagerDecorator $em, Products $products, AvailabilityService $availabilityService)
	{
		$this->translator = $translator;
		$this->em = $em;
		$this->products = $products;
		$this->availabilityService = $availabilityService;
	}

	public function getContainer(bool $multilang = false): BaseContainer
	{
		$row = new BaseContainer();
		$chbox = $row->addCheckbox('selected');
		$row->addText('code', null)
				  ->addConditionOn($chbox, BaseForm::EQUAL, 1)
				  	->setRequired();
		$row->addInteger('inStock', null)
				  ->addConditionOn($chbox, BaseForm::EQUAL, 1)
				  	->setRequired()
					->addRule(BaseForm::MIN, null, 0);
		$row->addBool('isActive');
		$row->addSelect('availability', null)
				->setPrompt(' ')
				->setItems($this->availabilityService->getOptionsForSelect())
				->addConditionOn($chbox, BaseForm::EQUAL, 1)
					->setRequired();

		return $row;
	}

	public function saveData(array $data, Supplier $supplier, Product $product, ?Availability $availabilityAfterSoldOut): void
	{
		$ps = new ProductSupplier($product, $supplier);
		$ps->code = $data['code'];
		$ps->quantity = $data['inStock'];
		$ps->isActive = (int) $data['isActive'];
		$ps->availabilityAfterSoldOut = $availabilityAfterSoldOut;
		$this->em->persist($ps);
	}

}