import {tns} from "tiny-slider/src/tiny-slider";

document.addEventListener('DOMContentLoaded', () => {
	/**
	 * General tabs logic
	 * [data-tabs] => triggers the target
	 * [data-tabs-content] => Defines the target
	 * [data-tabs-group] => Sets target to the switching group
	 * [data-tabs-default] => Sets default target to be visible
	 */
	const tabs = document.querySelectorAll('[data-tabs]');
	tabs.forEach(el => {
		el.addEventListener('click', () => {
			const tabTarget        = el.dataset.tabs;
			const tabsContent      = document.querySelector(`[data-tabs-content="${tabTarget}"]`);
			const tabGroup         = tabsContent.dataset.tabsGroup;
			const tabGroupElements = document.querySelectorAll(`[data-tabs-group="${tabGroup}"]`);

			tabs.forEach((tab) => tab.classList.remove('active'));
			el.classList.add('active');
			tabGroupElements.forEach(el => el.style.display = 'none');
			tabsContent.style.display = 'block';
		});
	});

	document.querySelectorAll(`[data-tabs-content]`).forEach(el => {
		el.style.display = 'none';
	});

	document.querySelectorAll('[data-tabs-default]').forEach(el => {
		const tabTarget           = el.dataset.tabs;
		const tabsContent         = document.querySelector(`[data-tabs-content="${tabTarget}"]`);
		tabsContent.style.display = 'block';
		tabsContent.classList.add('active');
		el.classList.add('active');
	});

	/**
	 * Úvodní obrázek slider
	 */
	const productSlider = document.getElementById('product-slider');
	const slider = tns({
		container: productSlider,
		items: 1,
		controls: false,
		autoplayButtonOutput: false,
		nav: false,
		mouseDrag: true
	});

	const previews = document.querySelectorAll('.product-intro__preview');
	previews.forEach((el) => {
		el.addEventListener('click', () => {
			const id = el.dataset.slideId;
			slider.goTo(id);
		});
	});

	/**
	 * Produkt slider
	 */
	const previewContainers = document.querySelectorAll('.product-intro__slider-previews');
	previewContainers.forEach((el) => {
		const wrapper = el.closest('.product-intro__slider-previews-wrapper')
		const previewSlider = tns({
			container: el,
			loop: false,
			items: 4,
			controls: false,
			mouseDrag: true,
			autoplayButtonOutput: false,
			nav: false
		})
		if (wrapper) {
			const btnPrev = wrapper.querySelector('[data-controls=prev]');
			const btnNext = wrapper.querySelector('[data-controls=next]');
			if (btnPrev) {
				btnPrev.addEventListener('click', () => {
					previewSlider.goTo('prev')
				})
			}
			if (btnNext) {
				btnNext.addEventListener('click', () => {
					previewSlider.goTo('next')
				})
			}
		}
	})
});
