<?php declare(strict_types = 1);

namespace EshopCatalog\CronModule\Model;

use Core\Model\Entities\EntityManagerDecorator;
use EshopCatalog\Model\Entities\CategoryProduct;
use EshopCatalog\Model\Entities\ProductInSite;
use EshopCatalog\Model\Entities\ProductVariant;

class ProductsVariants
{
	protected EntityManagerDecorator $em;

	public function __construct(EntityManagerDecorator $em)
	{
		$this->em = $em;
	}

	public function reSetAllCategories()
	{
		$variants = [];
		$map      = [];
		foreach ($this->em->createQueryBuilder()->select('IDENTITY(pv.product) as prod, pv.isDefault, pv.variantId')
			         ->from(ProductVariant::class, 'pv')
			         ->orderBy('pv.isDefault', 'DESC')
			         ->getQuery()->getArrayResult() as $row) {
			if ($row['isDefault'] == 1) {
				$variants[$row['prod']] = [];
				$map[$row['variantId']] = $row['prod'];
			} else {
				$variants[$map[$row['variantId']]][] = $row['prod'];
			}
		}

		$categories = [];
		foreach ($this->em->createQueryBuilder()->select('IDENTITY(cp.product) as prod, IDENTITY(cp.category) as cat')
			         ->from(CategoryProduct::class, 'cp')
			         ->getQuery()->getScalarResult() as $row) {
			$categories[$row['prod']][] = $row['cat'];
		}

		$sites = [];
		foreach ($this->em->createQueryBuilder()->select('IDENTITY(ps.product) as prod, IDENTITY(ps.site) as site, ps.isActive, IDENTITY(ps.category) as cat')
			         ->from(ProductInSite::class, 'ps')
			         ->getQuery()->getScalarResult() as $row) {
			$sites[$row['prod']][$row['site']] = $row;
		}

		foreach ($variants as $baseProdId => $prods) {
			if (!$prods)
				continue;

			$this->em->getConnection()->executeStatement("DELETE FROM eshop_catalog__category_product WHERE id_product IN (" . implode(', ', $prods) . ")");

			$ins = [];
			foreach ($categories[$baseProdId] ?? [] as $cat) {
				foreach ($prods as $prodId) {
					$ins[] = "($prodId, $cat)";
				}
			}

			if ($ins)
				$this->em->getConnection()->executeStatement("INSERT INTO eshop_catalog__category_product (id_product, id_category) VALUES " . implode(', ', $ins));

			$this->em->getConnection()->executeStatement("DELETE FROM eshop_catalog__product_in_site WHERE product_id IN (" . implode(', ', $prods) . ")");

			$ins = [];
			foreach ($sites[$baseProdId] as $site => $vals) {
				foreach ($prods as $prodId) {
					$ins[] = '(' . implode(', ', [
							$prodId,
							"'$site'",
							(int) $vals['isActive'],
							(is_null($vals['cat']) ? 'NULL' : (int) $vals['cat']),
						]) . ')';
				}
			}

			if ($ins)
				$this->em->getConnection()->executeStatement("INSERT INTO eshop_catalog__product_in_site (product_id, site, is_active, category_id) VALUES " . implode(', ', $ins));
		}
	}
}
