<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Core\Model\Helpers\Strings;

/**
 * Class RelatedGroup
 * @package EshopCatalog\FrontModule\Model\Dao
 */
class RelatedGroup
{
	/** @var int */
	protected int $id;

	/** @var string */
	protected string $name;

	/** @var Product[] */
	protected array $products = [];

	/**
	 * RelatedGroup constructor.
	 *
	 * @param int    $id
	 * @param string $name
	 */
	public function __construct(int $id, string $name)
	{
		$this->id   = $id;
		$this->name = $name;
	}

	/**
	 * @return string
	 */
	public function getName(): string { return $this->name; }

	/**
	 * @return int
	 */
	public function getId(): int { return $this->id; }

	/**
	 * @param Product $product
	 *
	 * @return $this
	 */
	public function addProduct(Product $product): self
	{
		$this->products[] = $product;

		return $this;
	}

	/**
	 * @return array|Product[]
	 */
	public function getProducts(): array { return $this->products; }
}
