<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="eshop_catalog__tag_texts")
 * @ORM\Entity
 * @ORM\EntityListeners({"TagTextListener"})
 */
class TagText
{

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Tag", inversedBy="texts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="tag", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $tag;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2)
	 */
	private $lang;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=255, nullable=true)
	 */
	public $name;

	public function __construct($tag, $lang)
	{
		$this->tag  = $tag;
		$this->lang = $lang;
	}

	public function getLang()
	{
		return $this->lang;
	}
}
