<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Tags;

use Core\Components\Flashes\Flashes;
use Core\Model\UI\BaseControl;
use Nette\Utils\Html;
use EshopCatalog\Model\Entities\Tag;
use EshopCatalog\AdminModule\Model\Tags;

class TagsGrid extends BaseControl
{
	/** @var \EshopCatalog\AdminModule\Model\Tags */
	protected $tagServices;

	public function __construct(Tags $tags)
	{
		$this->tagServices = $tags;
	}

	public function render()
	{
		$this->template->setFile(__DIR__ . '/TagsGrid.latte');
		$this->template->render();
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();
		$grid->setDefaultPerPage(20);

		$qb = $this->tagServices->getEr()->createQueryBuilder('t')
			->leftJoin('t.texts', 'tt', 'WITH', 'tt.lang = :lang')
			->setParameter('lang', $this->translator->getLocale())
			->getQuery()->getResult();

		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnText('type', 'eshopCatalog.defaultGrid.type');
		$grid->addColumnLink('name', 'eshopCatalog.defaultGrid.name', 'Products:editTag')->setRenderer(function($row) {
			return $row->getText()->name;
		});


		// Actions
		$grid->addAction('edit', '', 'Products:editTag')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setIcon('times')->setBsType('danger')->addClass('ajax');

		// Columns prototype

		return $grid;
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->tagServices->remove($id))
			$presenter->flashMessage('eshopCatalog.defaultGrid.removed', Flashes::FLASH_SUCCESS);
		else
			$presenter->flashMessage('eshopCatalog.defaultGrid.removeFailed', Flashes::FLASH_DANGER);

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}
}
