document.addEventListener('DOMContentLoaded', () => {
	const addButton = document.querySelector('.setChangePlan');

	if (addButton) {
		addButton.addEventListener('click', () => {
			const columnSelect = document.querySelector('[name="changePlan[column]"]');

			let data = {
				'changeAt': document.querySelector('[name="changePlan[changeAt]"]').value,
				'products': document.querySelector('[name="changePlan[products]"]').value,
			};

			if (columnSelect) {
				const columnSelectValue = columnSelect.options[columnSelect.selectedIndex].value;
				data['column']          = columnSelect.value;

				if (columnSelectValue === 'vatRate') {
					let tmp       = document.querySelector('[name="changePlan[vatRate]"]');
					data['value'] = tmp.value;
				}
			}

			global.naja.makeRequest('post', addButton.dataset.link, data, {
				history: false,
			}).then((response) => {
				if (response.dataTable) {
					let existTable = document.querySelector('.productChangePlanTable');
					if (existTable) {
						existTable.outerHTML = response.dataTable;
					}
				}
			});
		});
	}
});

document.addEventListener('click', e => {
	const target = e.target;

	if (target.classList.contains('removeChangePlan')) {
		e.preventDefault();

		global.naja.makeRequest('post', target.dataset.link, {
			id     : target.closest('tr').dataset.id,
			product: target.closest('tr').dataset.product,
		}, {
			history: false,
		}).then((response) => {
			if (response.dataTable) {
				let existTable = document.querySelector('.productChangePlanTable');
				if (existTable) {
					existTable.outerHTML = response.dataTable;
				}
			}
		});

		return false;
	}
})
