
// initialization of items
const initVideos = () => {
	let items = document.querySelectorAll('#item-videos .row');
	let count = items.length;

	items.forEach(function (el, key) {
		el.classList.add('d-none');
	});

	let i = -1;
	document.querySelectorAll('#item-videos input[name*="[id]"]').forEach(function (element, k) {
		if (element.value.length > 0) {
			items.forEach(function (el, key) {
				if (key <= k) {
					el.classList.remove('d-none');
				}
				i = k;
			});
		}
	});

	if ((i + 1) < count) {
		items[i + 1].classList.remove('d-none');
	}
}

const initAddButton = () => {
	// add row by btn
	document.getElementById('video-add').addEventListener('click', (e) => {
		e.stopPropagation();
		let items = document.querySelectorAll('#item-videos .row');
		let count = items.length;

		// remember last filled row
		let k = null;
		document.querySelectorAll('#item-videos .row:not(.d-none)').forEach(function (el, key) {
			k = key;
		})
		// first empty row after filled row show
		if (k !== null && (k + 1) < count) {
			items[k + 1].classList.remove('d-none');
		}

	});
};

const initRemoveButtons = () => {
	document.querySelectorAll('#item-videos .remove-video').forEach(function (el, key) {
		el.addEventListener('click', () => {
			let link = document.querySelectorAll('#item-videos input[name*=removeLink]')[key];

			if (link.value.length > 0) {
				window.naja.makeRequest('post', link.value, {}, {
					history: false
				});
			}

			document.querySelectorAll('#item-videos .row')[key].querySelectorAll('input, select').forEach((el, key) => {
				if (el.tagName === 'SELECT') {
					el.selectedIndex = 0;
				} else {
					el.value = null;
				}
				initVideos();
			});
		})
	});
};

document.addEventListener('DOMContentLoaded', () => {
	initAddButton();
	initRemoveButtons();
	initVideos();
	window.naja.addEventListener('complete', () => {
		initRemoveButtons();
		initVideos();
	});
});
