<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\AdminTools\DataFeed;

use Core\AdminModule\Model\Sites;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Doctrine\DBAL\ArrayParameterType;
use Exception;
use Nette\Utils\ArrayHash;

class ZboziCustomColumn extends BaseControl
{
	protected ?array $cCurrentData = null;
	protected array  $idents       = [];

	public function __construct(
		protected Sites $sitesService,
	)
	{
		foreach ($this->sitesService->getOptionsForSelect() as $site) {
			$this->idents[$site] = $site . 'ZboziCustomColumn';
		}
	}

	public function render(): void
	{
		$this->template->thisForm = $this['form'];
		$this->template->idents   = $this->idents;
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();

		foreach ($this->idents as $ident => $name) {
			$container = $form->addContainer($name);

			$container->addBool('isActive', 'default.isActive')
				->setIsMultilanguage();
			$container->addText('url', 'eshopCatalog.adminTools.dataFeed.zboziCustomColumn.url')
				->setIsMultilanguage();
		}


		$form->addSubmit('submit', 'default.save');

		$d = [];
		foreach ($this->loadCurrentData() as $siteIdent => $rows) {
			foreach ($rows as $row) {
				$l = $row['lang'];

				$d[$siteIdent]['isActive'][$l] = (bool) $row['is_active'];
				$d[$siteIdent]['url'][$l]      = $row['url'];
			}
		}

		$form->setDefaults($d);

		$form->onSuccess[] = $this->formSuccess(...);

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		try {
			$conn   = $this->em->getConnection();
			$exists = $this->loadCurrentData();

			$langValues = $form->convertMultilangValuesToArray();

			foreach ($langValues as $l => $rows) {
				foreach ($rows as $ident => $vals) {
					$exist = $exists[$ident][$l] ?? null;

					if ($exist) {
						$conn->update('eshop_catalog__data_feed', [
							'url'       => $vals['url'],
							'is_active' => (int) $vals['isActive'],
						], [
							'id'   => $exist['id'],
							'lang' => $l,
						]);
					} else {
						$conn->insert('eshop_catalog__data_feed', [
							'lang'      => $l,
							'ident'     => $ident,
							'url'       => $vals['url'],
							'is_active' => (int) $vals['isActive'],
						]);
					}
				}
			}
			$this->presenter->flashMessageSuccess('default.saved');
		} catch (Exception $e) {
			$this->presenter->flashMessageDanger('default.error');
		}

		$this->presenter->redirect('this');
	}

	protected function loadCurrentData(): array
	{
		if ($this->cCurrentData === null) {
			$this->cCurrentData = [];

			foreach ($this->em->getConnection()->fetchAllAssociative("SELECT id, ident, lang, url, params, is_active FROM eshop_catalog__data_feed WHERE ident IN (:ident)", [
				'ident' => $this->idents,
			], [
				'ident' => ArrayParameterType::STRING,
			]) as $row) {
				/** @var array $row */
				$this->cCurrentData[$row['ident']][$row['lang']] = $row;
			}
		}

		return $this->cCurrentData;
	}
}
