<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\ImportExport;

use Core\Model\Http\CsvResponse;
use Core\Model\UI\BaseControl;
use Exception;
use Nette\Http\Request;
use Nette\Utils\DateTime;

class DuplicatedCategoryData extends BaseControl
{
	public function __construct(
		protected Request $request,
	)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	public function handleExportName(): void
	{
		CsvResponse::sendResponse(
			$this->t('eshopCatalog.duplicatedCategoryData.nameFilename') . ' ' . (new DateTime)->format('Y-m-d H-i') . '.csv',
			$this->prepareCsv('name'),
		);
	}

	public function handleExportNameH1(): void
	{
		CsvResponse::sendResponse(
			$this->t('eshopCatalog.duplicatedCategoryData.nameH1Filename') . ' ' . (new DateTime)->format('Y-m-d H-i') . '.csv',
			$this->prepareCsv('name_h1'),
		);
	}

	public function handleExportAlias(): void
	{
		CsvResponse::sendResponse(
			$this->t('eshopCatalog.duplicatedCategoryData.aliasFilename') . ' ' . (new DateTime)->format('Y-m-d H-i') . '.csv',
			$this->prepareCsv('alias'),
		);
	}

	protected function prepareCsv(string $column): ?string
	{
		$url = $this->request->getUrl()->getBaseUrl();

		$fp = fopen('php://memory', 'wb+');
		if (!$fp) {
			throw new Exception('Failed open stream');
		}

		fputcsv($fp, [
			$this->t('eshopCatalog.duplicatedCategoryData.lang'),
			$this->t('eshopCatalog.duplicatedCategoryData.' . $column),
			$this->t('eshopCatalog.duplicatedCategoryData.id'),
			$this->t('eshopCatalog.duplicatedCategoryData.adminLink'),
		], ',');

		foreach ($this->em->getConnection()->executeQuery("
			SELECT GROUP_CONCAT(ct.id) as ids, ct.{$column}, ct.lang, COUNT(*)
			FROM eshop_catalog__category_texts ct
			INNER JOIN eshop_catalog__category c ON ct.id = c.id
			GROUP BY c.tree_root, ct.lang, ct.{$column}
			HAVING COUNT(*) > 1
			")->fetchAllAssociative() as $row) {
			if (!$row[$column]) {
				continue;
			}

			$ids = explode(',', (string) $row['ids']);

			$id = array_shift($ids);
			fputcsv($fp, [
				$row['lang'],
				$row[$column],
				$id,
				$url . 'admin/eshop-catalog/categories/edit/' . $id . '?categoryForm-categoryId=' . $id,
			]);

			while ($ids !== []) {
				$id = array_shift($ids);
				fputcsv($fp, [
					'',
					'',
					$id,
					$url . 'admin/eshop-catalog/categories/edit/' . $id . '?categoryForm-categoryId=' . $id,
				]);
			}
		}

		rewind($fp);
		$output = stream_get_contents($fp);

		fclose($fp);

		return $output ?: null;
	}

}
