<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Products;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\AdminModule\Model\Products;
use EshopCatalog\AdminModule\Model\Tags;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Entities\ProductTag;
use Nette\Caching\Cache;
use Nette\Utils\ArrayHash;

class ProductTagsForm extends BaseControl
{
	public function __construct(
		protected TagsContainer $tagsContainer,
		protected Products      $products,
		protected CacheService  $cacheService,
		protected Tags          $tags,
	)
	{
	}

	public function render(): void
	{
		$this->template->thisForm = $this['form'];
		$this->template->render($this->getTemplateFile());
	}

	public function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->addComponent($this->tagsContainer->getContainer(), 'tags');
		$form->addCheckbox('removeDisabled', 'eshopCatalog.productTagsForm.removeDisabledFromProducts')
			->setDefaultValue(0);

		$form->addSaveCancelControl();

		$form->onSuccess[] = $this->formSuccess(...);

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		$productsIds = $this->presenter->getParameter('ids');
		$form->addCustomData('productIds', $productsIds);

		if ($productsIds) {
			$productsIds = explode('-', (string) $productsIds);
			/** @var ProductTag[][] $activeTags */
			$activeTags = [];
			foreach ($this->em->getRepository(ProductTag::class)->createQueryBuilder('pt')
				         ->andWhere('pt.product IN (:ids)')->setParameter('ids', $productsIds)
				         ->getQuery()->getResult() as $row) {
				/** @var ProductTag $row */
				$activeTags[$row->getTag()->getId()][$row->getProduct()->getId()] = $row;
			}

			foreach ($values->tags as $vals) {
				if ($vals->active === 0) {
					// Odstranit neaktivni pokud je zvoleno
					if ($values->removeDisabled === true) {
						foreach ($activeTags[$vals->id] as $productTag) {
							$this->em->remove($productTag);
						}
					}

					continue;
				}

				// Projdutui vybranuch produkt a prirazeni stitku
				foreach ($productsIds as $productId) {
					/** @var ProductTag|null $productTag */
					$productTag = $activeTags[$vals->id][$productId] ?? null;

					if (!$productTag) {
						$productTag = new ProductTag($this->products->getReference($productId), $this->tags->getReference($vals->id));
					}

					$productTag->validFrom = $vals->dateFrom;
					$productTag->validTo   = $vals->dateTo;
					$this->em->persist($productTag);
				}
			}

			$this->em->flush();

			foreach ($productsIds as $id) {
				$this->products->clearProductCache((int) $id);
			}

			$this->cacheService->defaultCache->clean([Cache::TAGS => ['productsByTag']]);
		}

		return true;
	}

}
