<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model\AdminTools;

use Core\Model\Entities\EntityManagerDecorator;
use EshopProductsComparison\Model\Helpers\ExportEnums;

class ZboziCustomColumn
{
	protected array $cLoaded = [];

	public function __construct(
		protected EntityManagerDecorator $em
	)
	{
	}

	public function preloadChanged(): void
	{
		$this->cLoaded = [];

		foreach ($this->em->getConnection()
			         ->iterateAssociative("SELECT id, lang, custom_label1_source FROM eshop_products_comparison__product_export WHERE service = :service AND custom_label1_source = :source", [
				         'service' => ExportEnums::SERVICE_ZBOZI,
				         'source'  => 'auto',
			         ]) as $row) {
			/** @var array $row */
			$this->cLoaded[$row['id']][$row['lang']] = $row['custom_label1_source'];
		}
	}

	public function resetPrevChanged(): void
	{
		$conn = $this->em->getConnection();

		foreach ($this->cLoaded as $productId => $langs) {
			foreach ($langs as $lang => $source) {

				$conn->update('eshop_products_comparison__product_export', [
					'custom_label1'        => null,
					'custom_label1_source' => null,
				], [
					'service' => ExportEnums::SERVICE_ZBOZI,
					'id'      => $productId,
					'lang'    => $lang,
				]);
			}
		}

		$this->cLoaded = [];
	}

	public function processData(string $siteIdent): void
	{
		$conn = $this->em->getConnection();

		foreach ($conn->iterateAssociative("SELECT url, lang FROM eshop_catalog__data_feed WHERE ident = :ident AND is_active = :isActive", [
			'isActive' => 1,
			'ident'    => $siteIdent . 'ZboziCustomColumn',
		]) as $row) {
			/** @var array $row */
			$csvContent = $row['url'] ? file_get_contents((string) $row['url']) : '';
			if (!$csvContent || !$row['lang']) {
				continue;
			}

			$lines = str_getcsv($csvContent, "\n");
			foreach ($lines as $line) {
				$data = str_getcsv($line, ',');
				if (count($data) < 2) {
					continue;
				}

				$productId   = (int) $data[0];
				$customLabel = $data[1];

				$conn->update('eshop_products_comparison__product_export', [
					'custom_label1'        => $customLabel,
					'custom_label1_source' => 'auto',
				], [
					'service' => ExportEnums::SERVICE_ZBOZI,
					'id'      => $productId,
					'lang'    => $row['lang'],
				]);

				unset($this->cLoaded[$productId][$row['lang']]);
			}

			$conn->update('eshop_catalog__data_feed', [
				'last_run' => (new \DateTime())->format('Y-m-d H:i:s'),
			], [
				'ident' => $siteIdent . 'ZboziCustomColumn',
				'lang'  => $row['lang'],
			]);
		}
	}
}
