<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model\FormContainers;

use Contributte\Translation\Translator;
use Core\Model\Countries;
use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\UI\Form\BaseContainer;
use EshopCatalog\AdminModule\Model\Helpers\PricesHelper;
use EshopCatalog\AdminModule\Model\ProductPriceLevelCountries;
use EshopCatalog\AdminModule\Model\Products;
use EshopCatalog\Model\Config;
use EshopCatalog\Model\Entities\Product;
use EshopOrders\AdminModule\Model\GroupsCustomers;

class ProductPriceLevelCountriesContainer
{
	public function __construct(
		protected Translator                 $translator,
		protected EntityManagerDecorator     $em,
		protected Products                   $products,
		protected ProductPriceLevelCountries $productPriceLevelCountries,
		protected Countries                  $countries,
		protected GroupsCustomers            $groupsCustomers,
		protected PricesHelper               $pricesHelper,
	)
	{
	}

	public function getContainer(): BaseContainer
	{
		$container = new BaseContainer;
		$container->addCustomData('template', __DIR__ . '/ProductPriceLevelCountriesContainer.latte');

		$labels = [
			'price'    => 'eshopCatalog.productPricesContainer.price' . (Config::load('product.priceIsWithoutVat', false) ? 'WithoutVat' : ''),
			'group'    => 'eshopCatalog.productPricesContainer.customerGroup',
			'currency' => 'eshopCatalog.productPricesContainer.currency',
		];

		$currencies = [];
		foreach ((array) \Currency\Model\Config::load('whitelist') ?: [] as $v) {
			$currencies[$v] = $v;
		}

		foreach (array_keys($this->groupsCustomers->getOptionsForSelect()) as $groupId) {
			$rowGroup = $container->addContainer($groupId);

			foreach (array_keys($this->countries->getAllNameColumn()) as $countryId) {
				$row = $rowGroup->addContainer($countryId);

				$row->addText('price', $labels['price'])
					->setHtmlType('number')
					->setHtmlAttribute('step', .01)
					->setHtmlAttribute('min', 0);
				$row->addSelect('currency', $labels['currency'], ['' => ''] + $currencies);
			}
		}

		return $container;
	}

	public function saveData(Product $product, array $data): void
	{
		$this->pricesHelper->savePriceLevelCountriesToProduct($product, $data);
	}

	public function setDefaults(BaseContainer $container, Product $product): void
	{
		$d = [];
		foreach ($product->getPriceLevelCountriesIndexedByGroup() as $groupId => $countries) {
			foreach ($countries as $countryId => $row) {
				$d[$groupId][$countryId] = [
					'price'    => $row->price,
					'currency' => $row->currency,
				];
			}
		}

		$container->setDefaults($d);
	}

}
