<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model\Helpers;

use Core\AdminModule\Model\Sites;
use Core\Model\Countries;
use EshopCatalog\AdminModule\Model\AvailabilityService;
use EshopCatalog\AdminModule\Model\ProductPriceLevels;
use EshopCatalog\Model\Config;
use EshopOrders\AdminModule\Model\GroupsCustomers;
use EshopOrders\Model\Entities\GroupCustomers;

class ProductFormHelper
{
	/** @var GroupCustomers[]|null */
	protected ?array $groupCustomers = null;

	public function __construct(
		public GroupsCustomers     $groupsCustomersService,
		public ProductPriceLevels  $productPriceLevelsService,
		public AvailabilityService $availabilityService,
		public Config              $config,
		public Sites               $sitesService,
		public Countries           $countries,
	)
	{
	}

	/**
	 * @return GroupCustomers[]
	 */
	public function getGroupCustomers(): array
	{
		if ($this->groupCustomers === null) {
			$this->groupCustomers = $this->groupsCustomersService->getEr()->createQueryBuilder('g', 'g.id')->getQuery()
				->getResult();
		}

		return $this->groupCustomers;
	}

}
