<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Entities\ProductDocument;
use Override;

/**
 * @method ProductDocument|null get(int $id)
 */
class ProductDocuments extends BaseEntityService
{
	protected $entityClass = ProductDocument::class;

	public function __construct(
		protected CacheService $cacheService,
	)
	{
	}

	/**
	 * @return ProductDocument[]
	 */
	public function getByProduct(int $productId): array
	{
		$qb = $this->getEr()->createQueryBuilder('pd');

		return $qb->join('pd.product', 'p')
			->where('p.id = :pid')
			->setParameter('pid', $productId)
			->getQuery()->getResult();
	}

	/**
	 * @inheritDoc
	 */
	#[Override]
	public function remove($id): bool
	{
		$document = $this->get((int) $id);

		if ($document) {
			$productId = $document->product->getId();
			$result    = parent::remove($id);
			$this->cacheService->removeDocuments([$productId]);

			return $result;
		}

		return false;
	}

}
